require "behaviours/wander"
require "behaviours/follow"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/doaction"
--require "behaviours/choptree"
require "behaviours/findlight"
require "behaviours/panic"
require "behaviours/chattynode"
require "behaviours/leash"

require "behaviours/chaseandattack"

local RUN_THRESH = 4.5
local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8
local MAX_CHASE_TIME = 10
local MAX_CHASE_DIST = 20
local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8

local MIN_FOLLOW = 0.01
local MAX_FOLLOW = 37
local MED_FOLLOW = 5
local MAX_WANDER_DIST = 4



local summonclonebrain = Class(Brain, function(self, inst)
    Brain._ctor(self,inst)
end)


function summonclonebrain:OnStart()

    local root = PriorityNode(
    {
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW, MED_FOLLOW, MAX_FOLLOW, true),

        WhileNode( function() return self.inst.components.combat.target and self.inst:HasTag("attackest") end, "AttackMomentarily",
            ChaseAndAttack(self.inst, MAX_CHASE_TIME) ),
	
    },1)
    
    self.bt = BT(self.inst, root)

end


return summonclonebrain


